<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\select2\Select2;
use yii\helpers\ArrayHelper;
use common\models\Groups;

/* @var $this yii\web\View */
/* @var $model backend\models\Admin */
/* @var $form yii\widgets\ActiveForm */
$data = ArrayHelper::map(Groups::find()->asArray()->all(), 'group', 'group');

$model->groups =  json_decode($model->groups); // initial value


?>

<div class="admin-form special-form-modal">

    <?php $form = ActiveForm::begin(); ?>

    <?= $form->field($model, 'username')->textInput(['maxlength' => true, 'readonly' => 'readonly']) ?>

    <?= $form->field($model, 'email')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'password_hash')->passwordInput(['placeholder' => 'Password'])->label('Password') ?>

    <?= $form->field($model, 'confirmPassword')->passwordInput(['placeholder' => 'Confirm Password'])->label('Confirm password')  ?>

    <?= $form->field($model, 'status')->widget(Select2::classname(), [
            'data' => [
                '0' => 'Deleted',
                '9' => 'Inactive',
                '10' => 'Active',
                '1' => 'Confirmed',
                '0' => 'Not Comfirmed',
            ],
        ]); ?>

    <?= $form->field($model, 'groups')->widget(Select2::classname(), [
            'data' => $data,
            'options' => ['placeholder' => 'Select groups ...', 'multiple' => true],
            'pluginOptions' => [
                'tags' => true,
                'tokenSeparators' => [',', ' '],
                'maximumInputLength' => 10,
                'maintainOrder' => true
            ],
        ])->label('Access to groups'); ?>

    <?= $form->field($model, 'updated_at')->hiddenInput()->label(false) ?>

    <?php if (!Yii::$app->request->isAjax){ ?>
        <div class="form-group">
            <?= Html::submitButton($model->isNewRecord ? 'Create' : 'Update', ['class' => 'btn btn-primary  btn-bright']) ?>
        </div>
    <?php } ?>

    <?php ActiveForm::end(); ?>
    
</div>
